//
//  GrimReaperView.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

struct GrimReaperView: View {
    let severity: Double // 0.0 to 1.0
    
    @State private var isAnimating = false
    @State private var scytheRotation: Double = 0
    
    private var opacity: Double {
        0.3 + (severity * 0.7) // 0.3 to 1.0 based on severity
    }
    
    private var scale: Double {
        0.8 + (severity * 0.4) // 0.8 to 1.2 based on severity
    }
    
    var body: some View {
        VStack(spacing: 2) {
            ZStack {
                // Reaper figure (simplified representation)
                VStack(spacing: 1) {
                    // Hood/Head
                    Circle()
                        .fill(.black)
                        .frame(width: 16, height: 16)
                        .overlay(
                            Circle()
                                .stroke(.red, lineWidth: 1)
                                .opacity(severity)
                        )
                    
                    // Body
                    Rectangle()
                        .fill(.black)
                        .frame(width: 12, height: 20)
                        .cornerRadius(2)
                }
                
                // Animated scythe
                Image(systemName: "moon.fill")
                    .font(.caption)
                    .foregroundColor(.gray)
                    .rotationEffect(.degrees(scytheRotation))
                    .offset(x: 15, y: -5)
                    .animation(
                        Animation.easeInOut(duration: 2.0)
                            .repeatForever(autoreverses: true),
                        value: isAnimating
                    )
            }
            .scaleEffect(scale)
            .opacity(opacity)
            
            Text("Decline")
                .font(.caption2)
                .foregroundColor(.red)
                .opacity(opacity)
        }
        .onAppear {
            startAnimation()
        }
        .accessibility(label: Text("Health declining with severity level \(Int(severity * 100)) percent"))
    }
    
    private func startAnimation() {
        withAnimation {
            isAnimating = true
            scytheRotation = severity > 0.5 ? 20 : 10
        }
    }
}

#Preview {
    VStack(spacing: 20) {
        GrimReaperView(severity: 0.3)
        GrimReaperView(severity: 0.7)
        GrimReaperView(severity: 1.0)
    }
    .padding()
    .background(.gray.opacity(0.1))
}